-------------------------------------------------------------------------------
--                                                                           --
--  FILE          :  Univ_sim_Mod3                                           --
--  Related FILEs :  Mod3_pkg.vhd, Mod3.vhd                                  --
--                                                                           --
--  Author(s)     :  E. BOUTILLON                                            --
--                                                                           --
--  Organization  :  IUP LORIENT, MAITRISE GEII                              --                                                        --
--                                                                           --
--  Project       :  TP FPGA                                                 --
--                                                                           --
--  Creation Date :  05.02.2002                                              --
--                                                                           --
--  Simulator     :  Model Sim                                               --
--                                                                           --
--  Description   :  Univers de simulation du composant seuileur             --
-------------------------------------------------------------------------------
--                                History                                    --
-------------------------------------------------------------------------------
-- Version 1 : 25/01/2001 Creation                                           --
-------------------------------------------------------------------------------
LIBRARY work;
USE work.Mod3_pkg.all; 

-------------------------------------------------------------------------------
-- declaration de l'entite vide
-------------------------------------------------------------------------------
ENTITY Univ_sim_Mod3 IS
  
END Univ_sim_Mod3;

-------------------------------------------------------------------------------
-- Architecture synthetisable du composant Mod3
-------------------------------------------------------------------------------
ARCHITECTURE sim OF Univ_sim_Mod3 IS


-----------------------------------------------------------------------------
-- Declaration du composant Mod3
-----------------------------------------------------------------------------
COMPONENT Mod3
  	PORT (
  		rst       : IN  bit;                      -- signal reset actif a 0
		clk       : IN  bit;                      -- signal d'horloge   
 		b         : IN  bit;                      -- bit du mot (entre srie).
		start     : IN  bit;                      -- debut du calcul
		fin_calcul: IN  bit;                      -- fin du calcul
		alpha_num : OUT bit_vector(6 DOWNTO 0)    -- resultat
		);
END COMPONENT;
FOR ALL : Mod3 USE ENTITY work.Mod3(rtl);

-------------------------------------------------------------------------------
-- Declaration des signaux
-------------------------------------------------------------------------------
SIGNAL rst       : bit;                      -- signal reset actif a 0
SIGNAL clk       : bit;                      -- signal d'horloge   
SIGNAL b         : bit;                      -- entree valide  
SIGNAL start     : bit;                      -- debut des calculs
SIGNAL fin_calcul: bit;                      -- requete lecture donnee
SIGNAL alpha_num : bit_vector(6 DOWNTO 0);   -- resultat calcul

BEGIN

   ---------------------------------------------------------------
   -- Process reset
   ---------------------------------------------------------------
   reset :    PROCESS
   BEGIN
      rst <='0';
      WAIT FOR 47 ns;
      rst <= '1';
      WAIT;   -- On tue le process
   END PROCESS reset;

   ---------------------------------------------------------------
   -- Process d'horloge
   ---------------------------------------------------------------
   horloge :    PROCESS
   BEGIN
      clk <='1';
      WAIT FOR 10 ns;
      clk <= '0';
      WAIT FOR 10 ns;
   END PROCESS horloge;

   ----------------------------------------------------------------------------
   -- Process generation donnee
  ----------------------------------------------------------------------------
	Au_boulot : PROCESS

	BEGIN
		b <= '0'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL rst = '1';
		WAIT UNTIL clk = '1';
		WAIT UNTIL clk = '1';
		-- On met le premier mot : (101101) = 45 sur 6 bits 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '1'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '0'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '0'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '0'; start <= '0'; fin_calcul <= '1'; 
		WAIT UNTIL clk = '1'; 		 fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		 
		-- On met le deuxime mot : (1011100) = 92 sur 7 bits 
		WAIT UNTIL clk = '1'; 		b <= '0'; start <= '1'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '0'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '0'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '0'; start <= '0'; fin_calcul <= '1'; 
		WAIT UNTIL clk = '1'; 	fin_calcul <= '0'; 	 
		WAIT UNTIL clk = '1'; 		 
		-- On met le troisime mot : (0011111) = 31 sur 7 bits 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '1'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '1'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '0'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '0'; start <= '0'; fin_calcul <= '0'; 
		WAIT UNTIL clk = '1'; 		b <= '0'; start <= '0'; fin_calcul <= '1'; 
		WAIT UNTIL clk = '1'; 	fin_calcul <= '0'; 	 
		WAIT UNTIL clk = '1'; 
		 
		-- Fin de la simulation
	ASSERT FALSE REPORT "Simulation termine normalement" SEVERITY FAILURE;

	END PROCESS Au_Boulot;

   ---------------------------------------------------------------
   -- Instanciation du composant Mod3
   ---------------------------------------------------------------
   Composant_a_tester : Mod3 PORT MAP (
 	 		rst       => rst,
			clk       => clk,
 			b         => b,
			start     => start,
			fin_calcul=> fin_calcul,
			alpha_num => alpha_num 
			);

END sim;



