-------------------------------------------------------------------------------
--                                                                           --
--  FILE          :  Mod3_pkg.vhd                                            --
--  Related FILEs :                                                          --
--                                                                           --
--  Author(s)     :  E. BOUTILLON                                            --
--                                                                           --
--  Organization  :  IUP LORIENT, MAITRISE GEII                              --                                                        --
--                                                                           --
--  Project       :  TP FPGA                                                 --
--                                                                           --
--  Creation Date :  05.02.2002                                              --
--                                                                           --
--  Simulator     :  Model Sim                                               --
--                                                                           --
--  Description   :  Package du TP FPGA                                      --
-------------------------------------------------------------------------------
--                                History                                    --
-------------------------------------------------------------------------------
-- Version 1 : 25/01/2001 Creation                                           --
-------------------------------------------------------------------------------
LIBRARY std;
USE std.textio.all; 

-------------------------------------------------------------------------------
-- declaration du package
-------------------------------------------------------------------------------
PACKAGE Mod3_pkg IS

	TYPE valeur_modulo_type IS (mod0, mod1, mod2);

	TYPE etat_type IS (attente_start, bit_pair, bit_impair);


      TYPE modulo_type IS RECORD
        m    : valeur_modulo_type;
        etat : etat_type;
	END RECORD;


	------------------------------------------------------------------------
  -- Fonction calcul : calcul l'tat suivant  partir de l'tat courant
	--			   et des entres.
	-- Entre :
	--		X     : modulo_type : tat courant
	-- 		b     : bit : le bit du mot dont on calcule le reste modulo 3.
	-- 		start : bit : signal de controle indiquant l'arrive du premier bit
	-- 		fin_calcul : bit : signal de controle indiquant la fin du calcul
	--
	-- Sortie :
	--		modulo_type : tat futur.
	------------------------------------------------------------------------
	FUNCTION calcul( X : modulo_type; b : bit; start : bit; fin_calcul : bit) RETURN modulo_type;


	------------------------------------------------------------------------
      -- Fonction sortie : gnre le code BCD pour le controle des afficheurs
	--                   en fonction de l'tat du reste modulo 3
	-- Entre :
	--		X     : modulo_type : tat courant
	--
	-- Sortie :
	--		bit_vector : code BCD correspondant  l'affichage de 0, 1 ou 2.
	------------------------------------------------------------------------
	FUNCTION sortie( X : modulo_type) RETURN bit_vector;

	
END Mod3_PKG;


------------------------------------------------------------------------
------------------------------------------------------------------------
-- Definition du corp du package
------------------------------------------------------------------------
------------------------------------------------------------------------

PACKAGE BODY Mod3_pkg IS


	FUNCTION calcul( X : modulo_type; b : bit; start : bit; fin_calcul : bit) RETURN modulo_type IS
	
END Calcul;

FUNCTION sortie( X : modulo_type) RETURN bit_vector IS


BEGIN


END Mod3_pkg;


