-------------------------------------------------------------------------------
--                                                                           --
--  FILE          :  Mod3.vhd                                                --
--  Related FILEs :  Mod3_pkg.vhd                                            --
--                                                                           --
--  Author(s)     :  E. BOUTILLON                                            --
--                                                                           --
--  Organization  :  IUP LORIENT, MAITRISE GEII                              --                                                        --
--                                                                           --
--  Project       :  TP FPGA                                                 --
--                                                                           --
--  Creation Date :  05.02.2002                                              --
--                                                                           --
--  Simulator     :  Model Sim                                               --
--                                                                           --
--  Description   :  Composant permettant de calculer le reste modulo 3      --
--                   d'un nombre arrivant en serie (entree b).               --
--                   Le premier bit du mot est indiquer par le signal start  --
--                   present lors du meme cycle d'horloge. Apres l'arrive du --
--                   dernier bit, le signal fin_calcul passe  1.            --
--                   La sortie du systeme doit rester constante jusqu'a      --
--                   l'arrive d'un nouveau mot.                              -- 
-------------------------------------------------------------------------------
--                                History                                    --
-------------------------------------------------------------------------------
-- Version 1 : 25/01/2001 Creation                                           --
-------------------------------------------------------------------------------
LIBRARY work;
USE work.Mod3_pkg.all; 

-------------------------------------------------------------------------------
-- declaration de l'entite 
-------------------------------------------------------------------------------
ENTITY Mod3 IS
  	PORT (
  		rst       : IN  bit;                      -- signal reset actif a 0
		clk       : IN  bit;                      -- signal d'horloge   
 		b         : IN  bit;                      -- bit du mot (entre srie).
		start     : IN  bit;                      -- debut du calcul
		fin_calcul: IN  bit;                      -- fin du calcul
		alpha_num : OUT bit_vector(6 DOWNTO 0)    -- resultat
		);
END Mod3;

-------------------------------------------------------------------------------
-- Architecture synthetisable du composant Mod3
-------------------------------------------------------------------------------
ARCHITECTURE rtl OF Mod3 IS

BEGIN

  ----------------------------------------------------------------------------
  -- Process Calcul_modulo: process synchrone sur front montant avec reset
  --     asynchrone, calcul effectif du modulo.
  ----------------------------------------------------------------------------
	Au_boulot : PROCESS(rst, clk)

	VARIABLE X : modulo_type;
	BEGIN
		IF rst = '0' THEN
			X.m    := mod0;
			X.etat := attente_start;
		ELSIF clk'EVENT AND clk='1' THEN
			X := calcul(X, b, start, fin_calcul);
		END IF;

	END PROCESS Au_Boulot;
END rtl;


