-------------------------------------------------------------------------------
--                                                                           --
--  FILE          :  seuilleur.vhd                                           --
--  Related FILEs :  projet_vhdl_pkg.vhd                                     --
--                                                                           --
--  Author(s)     :                                                          --
--                                                                           --
--  Organization  :  IUP LORIENT, LICENCE GEII                               --                                                        --
--                                                                           --
--  Project       :  Projet VHDL                                             --
--                                                                           --
--  Creation Date :  25.01.2001                                              --
--                                                                           --
--  Simulator     :  Model Sim                                               --
--                                                                           --
--  Description   :  Entite, architecture du composant seuilleur             --                           --
--                   Ecriture : data_in_v est positionne a 1 en meme temps   --
--                               que data_in est valide.                     --
--                   Lecture : le cycle apres la requete (data_out_r = '1'), --
--                             le bus de sortie data_out contient la nouvelle--
--                             donnee                                        --                        
-------------------------------------------------------------------------------
--                                History                                    --
-------------------------------------------------------------------------------
-- Version 1 : 25/01/2001 Creation par E. Boutillon                        --
--             Definition entite, architecture permettant juste de valider   --       
--             une partie de l'environnement de test.                        --            
-------------------------------------------------------------------------------
LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY seuilleur IS
	PORT (
	rst       : IN  bit;                      -- signal reset actif a 0
        clk       : IN  bit;                      -- signal d'horloge   
        data_in   : INOUT  std_logic_vector(7 DOWNTO 0);    -- donnees entrees
        data_in_v : IN  bit;                      -- entree valide  
        start     : IN  bit;                      -- debut des calculs
        data_out_r: IN bit;                       -- requete lecture donnee
        end_c     : OUT bit                       -- fin des calculs
        );
END seuilleur;

-------------------------------------------------------------------------------
-- ARCHITECTURE  dummy                                                       --
-- Cette architecture permet juste de test l'environnement de test en        --
-- renvoyant en echo le signal start sur le signal end_c pour simuler la fin --
-- des calculs                                                               --
-------------------------------------------------------------------------------
ARCHITECTURE dummy OF seuilleur IS

-------------------------------------------------------------------------------
-- Declaration des signaux
-------------------------------------------------------------------------------
SIGNAL a : bit;

-------------------------------------------------------------------------------
-- Au boulot
-------------------------------------------------------------------------------
BEGIN

-------------------------------------------------------------------------------
-- Process dummy : Pour le test de l'environnement de test
--                 Renvoie le signal "end" en echo du signal "start"
-------------------------------------------------------------------------------
Echo : PROCESS 
BEGIN
	end_c <= '0';
	data_in <= "ZZZZZZZZ";
	WAIT UNTIL rst = '1';
	LOOP
		WAIT UNTIL start = '1';
		WAIT UNTIL clk = '1';
		WAIT UNTIL clk = '1';
		end_c <= '1';
		WAIT UNTIL clk = '1';
		end_c <= '0';
	END LOOP;	
END PROCESS Echo;

END dummy;





